<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('numerology_calculations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            $table->string('name');
            $table->date('birthdate');
            $table->string('industry')->nullable();
            $table->json('L5');
            $table->json('L6');
            $table->json('L7');
            $table->json('L8');
            $table->json('L9');
            $table->integer('root_number');
            $table->json('swot_combinations')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('numerology_calculations');
    }
};
